/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.sfp;

import com.ibm.hsc.access.api.AcaClient;
import com.ibm.hsc.auiml.databeans.sfp.SFPException;
import com.ibm.hsc.common.util.CIMUtils;
import com.ibm.hsc.common.util.HSCLocalizableMsg;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import java.util.Vector;
import org.snia.wbem.cim.CIMException;

public class SFPUtil {
    private static final String TRACE_MASKD = "JSFPUTLD";
    private static final String TRACE_MASKF = "JSFPUTLF";
    private static final String TRACE_MASKT = "JSFPUTLT";

    public static boolean checkSFPAccess(String string) throws SFPException {
        int n = 0;
        try {
            AcaClient acaClient = new AcaClient();
            Trace.trace((String)TRACE_MASKF, (Object)("accessClient.CheckAccess(" + string + "," + "WebSMPermission" + "," + "SFPPluginItem" + "," + "RepairServEvent" + ")"));
            n = acaClient.CheckAccess(string, "WebSMPermission", "SFPPluginItem", "RepairServEvent");
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKF, (Object)("Exception using AcaClient " + exception + "\n Setting write access to false"));
            n = 1;
        }
        Trace.trace((String)TRACE_MASKF, (Object)("Return code from CheckAccess was " + n));
        return n == 0;
    }

    public static Vector getMachineInfo() throws SFPException {
        Trace.trace((String)TRACE_MASKT, (Object)"-> SFPUtil.getMachineInfo()");
        Vector vector = null;
        try {
            vector = CIMUtils.getCECsInfo();
        }
        catch (CIMException cIMException) {
            SFPException sFPException = new SFPException("0008", cIMException);
            Trace.trace((String)TRACE_MASKT, (Object)"<- SFPUtil.getMachineInfo()");
            throw sFPException;
        }
        if (vector == null) {
            vector = new Vector();
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- SFPUtil.getMachineInfo()");
        return vector;
    }

    public static LocalizableText showSFPErrorMessageBox(String string, PanelTasklet panelTasklet) throws TaskletException {
        return SFPUtil.showSFPMessageBox(string, MsgType.ERROR_MESSAGE, "SFP_MESSAGE_ERROR_TITLE", panelTasklet);
    }

    public static LocalizableText showSFPInfoMessageBox(String string, PanelTasklet panelTasklet) throws TaskletException {
        return SFPUtil.showSFPMessageBox(string, MsgType.INFORMATION_MESSAGE, "SFP_MESSAGE_INFO_TITLE", panelTasklet);
    }

    private static LocalizableText showSFPMessageBox(String string, MsgType msgType, String string2, PanelTasklet panelTasklet) throws TaskletException {
        return SFPUtil.showMessageBox(true, new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", string2), new HSCLocalizableMsg(msgType, "S", "com.ibm.hsc.common.bundles.SFPResourceBundleMessages", string, null), panelTasklet);
    }

    public static LocalizableText showPlatformErrorMessageBox(String string, PanelTasklet panelTasklet) throws TaskletException {
        return SFPUtil.showPlatformMessageBox(string, MsgType.ERROR_MESSAGE, "PLFMGT_MESSAGE_ERROR_TITLE", panelTasklet);
    }

    public static LocalizableText showPlatformInfoMessageBox(String string, PanelTasklet panelTasklet) throws TaskletException {
        return SFPUtil.showPlatformMessageBox(string, MsgType.INFORMATION_MESSAGE, "PLFMGT_MESSAGE_INFO_TITLE", panelTasklet);
    }

    private static LocalizableText showPlatformMessageBox(String string, MsgType msgType, String string2, PanelTasklet panelTasklet) throws TaskletException {
        return SFPUtil.showMessageBox(true, new LocalizableText("com.ibm.hsc.common.bundles.PlatformBundle", string2), new HSCLocalizableMsg(msgType, "P", "com.ibm.hsc.common.bundles.PlatformBundleMessages", string, null), panelTasklet);
    }

    private static LocalizableText showMessageBox(boolean bl, LocalizableText localizableText, HSCLocalizableMsg hSCLocalizableMsg, PanelTasklet panelTasklet) throws IllegalArgumentException, TaskletException {
        if (hSCLocalizableMsg == null) {
            throw new IllegalArgumentException("The msg argument is invalid.");
        }
        return panelTasklet.showMessageBox(bl, localizableText, new MessageText[]{new MessageText(hSCLocalizableMsg.getResourceBundleName(), hSCLocalizableMsg.getKey(), hSCLocalizableMsg.getSubstitutionData(), hSCLocalizableMsg.getType(), hSCLocalizableMsg.getMsgId())}, null, null, null);
    }
}

